unit uDemoBezServiceLocator;

interface

uses
  Spring.Container, Spring.Services, Spring.Collections;

type
  IBro = interface
    ['{0F63DF32-F65F-4708-958E-E1931814EC33}']
    procedure Uyj;
  end;

  IWojownik = interface
    ['{0C926753-A70D-40E3-8C35-85CA2C4B18CA}']
    procedure Walcz;
  end;

  TPoleBitwy = class
  private
    FWojownik: IWojownik;
  public
    procedure DodajWojownika(aWojownika: IWojownik);
    procedure Bitwa;
  end;

  TMiecz = class(TInterfacedObject, IBro)
    procedure Uyj;
  end;

  TRycerz = class(TInterfacedObject, IWojownik)
  private
    FBro: IBro;
  public
    constructor Create(aBro: IBro);
    property Bro: IBro read FBro write FBro;
    procedure Walcz;
  end;

procedure RozpocznijBitw;

implementation

procedure TPoleBitwy.DodajWojownika(aWojownika: IWojownik);
begin
  FWojownik := aWojownika;
end;

procedure TPoleBitwy.Bitwa;
begin
  WriteLn('Bitwa si rozpocza!');
  FWojownik.Walcz;
end;

constructor TRycerz.Create(aBro: IBro);
begin
  inherited Create;
  FBro := aBro;
end;

procedure TRycerz.Walcz;
begin
  WriteLn('Rycerz rusza do boju!');
  FBro.Uyj;
end;

procedure TMiecz.Uyj;
begin
  WriteLn('Sycha szczk miecza!');
end;

{
procedure RozpocznijBitw;
var
  PoleBitwy: TPoleBitwy;
  TymczRycerz: IWojownik;
  TymczMiecz: IBro;
begin
  PoleBitwy := TPoleBitwy.Create;
  try
    TymczRycerz := ServiceLocator.GetService<IWojownik>;
    TymczMiecz := ServiceLocator.GetService<IBro>;
    TymczRycerz.Bro := TymczMiecz;
    PoleBitwy.DodajWojownika(TymczRycerz);
    PoleBitwy.Bitwa;
  finally
    PoleBitwy.Free;
  end;
end;
}

procedure RozpocznijBitw;
var
  PoleBitwy: TPoleBitwy;
begin
  PoleBitwy := ServiceLocator.GetService<TPoleBitwy>;
  try
    PoleBitwy.Bitwa;
  finally
    PoleBitwy.Free;
  end;
end;

initialization
{
  GlobalContainer.RegisterType<TMiecz>.Implements<IBro>('miecz');
  GlobalContainer.RegisterType<TRycerz>.Implements<IWojownik>('rycerz');
}
  GlobalContainer.RegisterType<TPoleBItwy>.InjectMethod('DodajWojownika', ['rycerz']);
  GlobalContainer.RegisterType<TMiecz>.Implements<IBro>('miecz');
  GlobalContainer.RegisterType<TRycerz>.Implements<IWojownik>('rycerz').InjectConstructor(['miecz']);
end.

